/* 
 * prids.c 
 *
 * Виводить власні ідентифікатори (PID, PPID, PGID, SID), свій
 * командний рядок та командні рядки, асоційовані з деякими
 * іншими процесами, пов'язаними з даним (батьківського процесу, 
 * лідера групи процесів, лідера сеансу). Командні рядки отримує за
 * допомогою зовнішньої програми ps, яку запускає через функцію system().
 * Ілюструє порядок застосування функції system().
 *
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
/* Для getsid(), getpgid() */
#define __USE_XOPEN_EXTENDED
#include <unistd.h>


/* Виводить командний рядок, асоційований з процесом, що має PID, 
   заданий аргументом pid. */
void print_command(unsigned int pid)
{
        char cmd[50];

        assert(pid > 0);

        sprintf(cmd, "ps -p %u -o cmd=", pid);
        system(cmd);
}

int main()
{
        unsigned int id;

        id = (unsigned int) getpid();
        printf("The process ID is %u\n", id);
        printf("Current process command line:\n");
        print_command(id);

        id = (unsigned int) getppid();
        printf("Parent process ID is %u\n", id);
        printf("Parent process command line:\n");
        print_command(id);

#if 0
        id = (unsigned int) getpgrp();
#endif
        id = (unsigned int) getpgid(0);
        printf("The process group ID is %u\n", id);
        printf("Group leader command line:\n");
        print_command(id);

        id = (unsigned int) getsid(0);
        printf("The process session ID is %u\n", id);
        printf("Session leader command line:\n");
        print_command(id);

        exit(EXIT_SUCCESS);
} 
